{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 31.10.98 - 17:56:35 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Activex,Windows, SysUtils, MMWave, MMHook, MMDesign, MMACMDlg, MMCstDlg, Dialogs, MMObj,
  MMDSPObj, MMWavOut, MMWInfo, Menus, Messages, Classes, Graphics, Controls,
  MMAbout, MMWaveIO, MMUtils, Forms, StdCtrls, MMSystem;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    About1: TMenuItem;
    Open1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Play1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    INFO1: TMenuItem;
    MMWaveInfoEditor1: TMMWaveInfoEditor;
    MMWaveOut1: TMMWaveOut;
    MMWaveOpenDialog1: TMMWaveOpenDialog;
    MMWaveSaveDialog1: TMMWaveSaveDialog;
    N3: TMenuItem;
    Convert1: TMenuItem;
    MMACM1: TMMACM;
    N4: TMenuItem;
    Filter1: TMenuItem;
    MMDesigner1: TMMDesigner;
    MMWaveFile1: TMMWaveFile;
    procedure Open1Click(Sender: TObject);
    procedure INFO1Click(Sender: TObject);
    procedure Play1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMWaveOut1Start(Sender: TObject);
    procedure MMWaveOut1Stop(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Convert1Click(Sender: TObject);
    procedure Filter1Click(Sender: TObject);
  public
    FontHeight: integer;

    function  FmtTimeStr(pwfx: PWaveFormatEx; aSample: Longint): String;
    procedure DumpExtraHeaderData(X, Y: integer; pwfx: PWaveFormatEx);
    procedure DumpWaveFormat(X, Y: integer);
    procedure ConvertPCM;
    procedure ConvertACM;
    procedure SaveProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                             Var Cancel: Boolean);
    procedure CvtProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                            Var Cancel: Boolean);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses Unit2,Unit3,Unit4;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
     Color := clWindow;
     Font.Handle := GetStockObject(ANSI_FIXED_FONT);
     try                                 { is the WAVE MAPPER installed ? }
        MMWaveOut1.DeviceID := WAVE_MAPPER;
     except
         On EMMWaveOutError do                    { WAVE MAPPER not inst. }
            MMWaveOut1.DeviceID := 0;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormPaint(Sender: TObject);
Var
   aStr: String;
   x, y: integer;

begin
    if (FontHeight = 0) then
       FontHeight := Canvas.TextHeight('W');

    x := 5;
    y := 5;

    FmtStr(aStr, '       Wave File Path: %s', [Uppercase(MMWaveFile1.Wave.FileName)]);
    if (MMWaveFile1.Wave.FileName = '') then aStr := aStr + '(none)';
    Canvas.TextOut(x, y, aStr);  inc(y, FontHeight);

    DumpWaveFormat(X, Y);
end;

{-- TMainForm ------------------------------------------------------------}
function TMainForm.FmtTimeStr(pwfx: PWaveFormatEx; aSample: Longint): String;
begin
   if (pwfx <> Nil) then
   begin
      Result := TimeToString(wioSamplesToTime(pwfx, aSample));
   end
   else Result := '';
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DumpExtraHeaderData(X, Y: integer; pwfx: PWaveFormatEx);
const
   DUMP_BYTES_PER_LINE = 16;

var
   lastx: integer;
   aStr : String;
   i, j : integer;
   pData: PByteArray;

begin
   if (pwfx^.wFormatTag = WAVE_FORMAT_PCM) or (pwfx^.cbSize = 0) then exit;

   { !!! this is really horrible code !!! }

   with Canvas do
   begin
      TextOut(x, y, 'Offset Data Bytes'); inc(y, FontHeight);
      TextOut(x, y, '------ -----------------------------------------------');
      inc(y, FontHeight);

      { extra info comes direct after the header ! }
      pData := Pointer(PChar(pwfx)+sizeOf(pwfx^));

      i := 0;
      while i < pwfx^.cbSize do
      begin
         lastx := x;
         FmtStr(aStr, '0x%.04X', [i]);
         TextOut(x, y, aStr); inc(x, TextWidth(aStr));

         for j := 0 to DUMP_BYTES_PER_LINE-1 do
         begin
            if (i + j >= pwfx^.cbSize) then break;

            FmtStr(aStr, ' %.02X', [pData^[i + j]]);
            TextOut(x, y, aStr); inc(x, TextWidth(aStr));
         end;
         x := lastx;
         inc(y,FontHeight);
         inc(i,DUMP_BYTES_PER_LINE)
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.DumpWaveFormat(X, Y: integer);
Var
   pwio : PWaveIOCB;
   pwfx : PWaveFormatEx;
   aStr : String;
   FormatTag, Format: String;

begin
   if not MMWaveFile1.Wave.Empty then
   with Canvas do
   begin
      pwio := MMWaveFile1.Wave.PWaveIOInfo;
      pwfx := @pwio^.wfx;

      FmtStr(aStr, '      Total File Size: %s bytes', [FormatBigNumber(pwio^.dwFileSize)]);
      TextOut(x, y, aStr);  inc(y, FontHeight+5);

      if not MMACM1.ACMPresent then
      begin
         wioGetFormatName(pwfx, FormatTag);
         wioGetFormat(pwfx, Format);
      end
      else MMACM1.GetFormatDescription(pwfx, FormatTag, Format);

      FmtStr(aStr, '               Format: %s', [FormatTag]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '           Attributes: %s', [Format]);
      TextOut(x, y, aStr);  inc(y, FontHeight+10);

      FmtStr(aStr, '     Total Data Bytes: %s bytes', [FormatBigNumber(pwio^.dwDataBytes)]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '   Total Data Samples: %s samples', [FormatBigNumber(pwio^.dwDataSamples)]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '           Total Time: %s', [FmtTimeStr(pwfx, pwio^.dwDataSamples)]);
      TextOut(x, y, aStr);  inc(y, FontHeight+10);

      FmtStr(aStr, '           Format Tag: %d', [pwfx^.wFormatTag]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '             Channels: %d', [pwfx^.nChannels]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '   Samples Per Second: %d', [pwfx^.nSamplesPerSec]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, ' Avg Bytes Per Second: %d', [pwfx^.nAvgBytesPerSec]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '      Block Alignment: %d', [pwfx^.nBlockAlign]);
      TextOut(x, y, aStr);  inc(y, FontHeight);

      FmtStr(aStr, '      Bits Per Sample: %d', [pwfx^.wBitsPerSample]);
      TextOut(x, y, aStr);  inc(y, FontHeight+5);

      if (pwfx^.wFormatTag <> WAVE_FORMAT_PCM) then
      begin
         FmtStr(aStr, '   Extra Header Bytes: %d', [pwfx^.cbSize]);
         TextOut(x, y, aStr);  inc(y, FontHeight+10);

         DumpExtraHeaderData(0, y, pwfx);
      end;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Open1Click(Sender: TObject);
begin
     MMWaveOpenDialog1.FileName := '*.wav';
     if MMWaveOpenDialog1.Execute then
     begin
          MMWaveFile1.Wave.FileName := '';
          MMWaveFile1.Wave.FileName := MMWaveOpenDialog1.Filename;
          SaveAs1.Enabled := True;
          Convert1.Enabled := True;
          if MMACM1.ACMPresent and (MMACM1.NumFilters > 0) then
             Filter1.Enabled := True;
          Play1.Enabled := True;
          INFO1.Enabled := True;
          Refresh;
     end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.CvtProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                                  Var Cancel: Boolean);
begin
     with CvtProgress do
     begin
        Gauge1.Progress := Round((CurByte * 100.0) / NumBytes+0.5);
     end;
     Cancel := CvtProgress.Cancel;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SaveProgressCB(Sender: TObject; CurByte, NumBytes: Longint;
                                   Var Cancel: Boolean);
begin
     with SaveProgress do
     begin
        Gauge1.Progress := Round((CurByte * 100.0) / NumBytes+0.5);
        lblDone.Caption := IntToStr(CurByte div 1024) + ' Kb';
        lblPercent.Caption := IntToStr(Gauge1.Progress) + ' %';
    end;
    Cancel := SaveProgress.Cancel;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.SaveAs1Click(Sender: TObject);
begin
   MMWaveSaveDialog1.FileName := '*.wav';
   if MMWaveSaveDialog1.Execute then
   begin
      try
         with SaveProgress do
         begin
            lblPercent.Caption := '0 %';
            lblSize.Caption := IntToStr(MMWaveFile1.Wave.FileSize div 1024)+ ' Kb';
            lblDone.Caption := '0 Kb';
            Gauge1.Progress := 0;
            BringToFront;
            Show;
         end;

         MMWaveFile1.Wave.OnProgress := SaveProgressCB;
         MMWaveFile1.Wave.SaveToFile(MMWaveSaveDialog1.FileName);

      finally
         SaveProgress.Close;
      end;

      { reset the Wave }
      MMWaveFile1.Wave.FreeWave;
      { set the new Wave }
      MMWaveFile1.Wave.FileName := MMWaveSaveDialog1.FileName;

      Refresh;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Convert1Click(Sender: TObject);
begin
   if MMACM1.ACMPresent and (MMACM1.NumConverters > 0) then ConvertACM
   else ConvertPCM;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ConvertPCM;
begin
   MMWaveSaveDialog1.FileName := '*.wav';
   if MMWaveSaveDialog1.Execute then
   begin
      { the ACM is not present, so we use our own conversion stuff }
      FmtDialog.Wave := MMWaveFile1.Wave;
      if (FmtDialog.ShowModal = mrOk) then
      begin
         try
            try
               with CvtProgress do
               begin
                  Gauge1.Progress := 0;
                  BringToFront;
                  Show;
               end;

               MMWaveFile1.Wave.OnProgress := CvtProgressCB;
               MMWaveFile1.Wave.ConvertFile(MMWaveSaveDialog1.FileName, FmtDialog.PWaveFormat);

            finally
               CvtProgress.Close;
            end;

            MessageDlg('Conversion completed successfully!',
                       mtInformation, [mbOk], 0);

            { reset the Wave }
            MMWaveFile1.Wave.FreeWave;
            { set the new Wave }
            MMWaveFile1.Wave.FileName := MMWaveSaveDialog1.FileName;

         except
            MessageDlg('Conversion aborted--destination file not created!',
                       mtError, [mbOk], 0);
         end;
      end
      else MessageDlg('Conversion aborted!', mtInformation, [mbOk], 0);
      Refresh;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.ConvertACM;
begin
   { select the filename }
   MMWaveSaveDialog1.FileName := '*.wav';
   if MMWaveSaveDialog1.Execute then
   begin
      { select the destination format using the ACM }
      MMACM1.EnumFormats := efConvert;
      if MMACM1.ChooseFormat(MMWaveFile1.Wave.PWaveFormat,'Destination Format') then
      begin
         try
            with CvtProgress do
            begin
               Gauge1.Progress := 0;
               BringToFront;
               Show;
            end;

            MMWaveFile1.Wave.OnProgress := CvtProgressCB;
            MMACM1.ConvertFile(MMWaveSaveDialog1.FileName);

         finally
            CvtProgress.Close;
         end;

         MessageDlg('Conversion completed successfully!',
                    mtInformation, [mbOk], 0);

         { reset the Wave }
         MMWaveFile1.Wave.FreeWave;
         { set the new Wave }
         MMWaveFile1.Wave.FileName := MMWaveSaveDialog1.FileName;
      end
      else MessageDlg('Conversion aborted!', mtInformation, [mbOk], 0);
      Refresh;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Filter1Click(Sender: TObject);
begin
   { select the filename }
   MMWaveSaveDialog1.FileName := '*.wav';
   if MMWaveSaveDialog1.Execute then
   begin
      { select the filter }
      if MMACM1.ChooseFilter(nil,'Select Filter') then
      begin
         try
            with SaveProgress do
            begin
               lblPercent.Caption := '0 %';
               lblSize.Caption := IntToStr(MMWaveFile1.Wave.FileSize div 1024)+ ' Kb';
               lblDone.Caption := '0 Kb';
               Gauge1.Progress := 0;
               BringToFront;
               Show;
            end;

            MMWaveFile1.Wave.OnProgress := SaveProgressCB;
            MMACM1.FilterFile(MMWaveSaveDialog1.FileName);

         finally
            SaveProgress.Close;
         end;

         MessageDlg('Filtering completed successfully!',
                    mtInformation, [mbOk], 0);

         { reset the Wave }
         MMWaveFile1.Wave.FreeWave;
         { set the new Wave }
         MMWaveFile1.Wave.FileName := MMWaveSaveDialog1.FileName;
      end
      else MessageDlg('Filtering aborted!', mtInformation, [mbOk], 0);
      Refresh;
   end;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Play1Click(Sender: TObject);
begin
     if (wosPlay in MMWaveOut1.State) then MMWaveOut1.Stop
     else MMWaveOut1.Start;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Start(Sender: TObject);
begin
     Play1.Caption := '&Stop';
     SaveAs1.Enabled := False;
     Convert1.Enabled := False;
     Filter1.Enabled := False;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Stop1Click(Sender: TObject);
begin
     MMWaveOut1.Stop;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.MMWaveOut1Stop(Sender: TObject);
begin
     MMWaveOut1.Close;
     Play1.Caption := '&Play';
     SaveAs1.Enabled := True;
     Convert1.Enabled := True;
     if MMACM1.ACMPresent and (MMACM1.NumFilters > 0) then
        Filter1.Enabled := True;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.INFO1Click(Sender: TObject);
begin
     MMWaveInfoEditor1.Execute;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.About1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
     Close;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     MMWaveOut1.Close;
end;

end.
